<?php
/**
 * Created by PhpStorm.
 * User: doanhcn2
 * Date: 03/08/2018
 * Time: 15:22
 */

namespace site;

class RedeemGC
{
    public function __construct()
    {
        add_action( 'woocommerce_cart_actions', array( $this, 'show_apply_giftcart_form' ) ); // show form to redeem gift card
        add_filter( 'woocommerce_get_price_html', array( $this, 'show_giftcard_price' ), 10, 2 ); // show gift card price instead of product price

        add_action('woocommerce_check_cart_items', array($this, 'apply_giftcard')); // check valid gift card and add to cart data

        add_filter('woocommerce_update_cart_validation',array($this,'checkGiftCardInCart'),10,4);

        // filter caculate discount
        add_filter('woocommerce_calculated_total', array($this, 'decrease_cart_total'), 10, 2); // sub total amount after caculated GC discount

        add_action('woocommerce_cart_totals_before_order_total', array($this, 'show_giftcard_discount_in_cart')); // show gift card discount in cart totals
        add_action('woocommerce_review_order_before_order_total', array($this, 'show_giftcard_discount_in_cart')); // show gift card discount in order review

//        add_filter('woocommerce_cart_taxes_total', array($this, 'display_tax_amount_after_apply_gc'), 10, 4);
//        add_filter('woocommerce_cart_get_shipping_total', array($this, 'display_shipping_amount_after_apply_gc'), 10, 1);
        add_action('woocommerce_check_cart_items', array($this, 'remove_giftcard_code'));

        add_action('woocommerce_checkout_process', array($this, 'check_gc_valid_before_checkout'));

        add_action('woocommerce_checkout_order_processed', array($this, 'process_after_checkout_sucess')); // remove discount after checkout, save data about gift card, gift card history
        add_filter('woocommerce_get_order_item_totals', array($this, 'show_giftcard_discount_on_order'), 10, 2); // save gift card to order

        add_action( 'woocommerce_admin_order_totals_after_discount', array($this, 'display_giftcard_on_order' ) );

    }

    public function show_apply_giftcart_form()
    {
        global $post;
        ob_start();
        $id            = 0;
        $template_path = GIFTCARD_PATH . 'template/';
        $default_path  = GIFTCARD_PATH . 'template/';
        wp_enqueue_script('apply_gc');
        wc_get_template( 'add_giftcart_form.php', array( 'id' => $id, ), $template_path, $default_path );
        echo ob_get_clean();
    }

    public function show_giftcard_price( $price, $product )
    {
        global $wpdb;
        //if (!is_single())  return $price;
        $post_id     = $product->get_id();
        $is_giftcard = get_post_meta( $post_id, '_giftcard', true );
        if ( $is_giftcard ) {
            $price_model = get_post_meta( $post_id, '_giftcard-price-model', true );
            switch ( $price_model ) {
                case 'fixed-price':
                {
                    return $price;
                    break;
                }
                case 'selected-price':
                {
                    $presets         = get_post_meta( $post_id, '_giftcard-preset-price', true );
                    $preset          = explode( ';', $presets );
                    $giftcard_code_mode = get_post_meta($post_id,'_giftcard_mode', true);
                    if($giftcard_code_mode == 'manual'){
                        $sql = "SELECT `post_id` as `giftcard_code_id` FROM `".$wpdb->prefix."postmeta` WHERE `meta_key` = 'gc_product_id' AND `meta_value` = ".$post_id;
                        $results = $wpdb->get_results($sql, ARRAY_A);
                        if(!empty($results)){
                            $giftcard_value = [];
                            foreach ($results as $result){
                                $giftcard_code_id[] = $result['giftcard_code_id'];
                                $query = "SELECT * FROM `".$wpdb->prefix."postmeta` WHERE `post_id` = ".$result['giftcard_code_id'];
                                $giftcardcode = $wpdb->get_results($query,ARRAY_A);
                                $value = get_post_meta($result['giftcard_code_id'],'gc_balance', true);
                                foreach ($giftcardcode as $giftcard){
                                    if($giftcard['meta_key'] == 'gc_status' && ($giftcard['meta_value'] == '-1' || $giftcard['meta_value'] == -1) && !in_array($value,$giftcard_value) && $value != ""){
                                        $giftcard_value[] = $value;
                                    }
                                }
                            }
                            sort($giftcard_value);
                            $preset = $giftcard_value;
                        }
                    }
                    if(!empty($preset)&&$presets != ""){
                        $count           = count( $preset );
                        sort($preset);
                        $from = $preset[0] != "" ? $preset[0] : $preset[1];
                        $to = $preset[ $count - 1 ];
                        $html            = __( 'From', 'GIFTCARD' ) . ' ' . wc_price( $from ) . __(' to ', 'GIFTCARD') . wc_price( $to );
                        if($giftcard_code_mode == 'manual'){
                            $update = "UPDATE `".$wpdb->prefix."postmeta` SET `meta_value`='instock' WHERE `meta_key`='_stock_status' AND `post_id`='".$post_id."'";
                            $wpdb->query($update);
                        }
                        return $html;
                    }
                    return '';
                    break;
                }
                case 'custom-price' :
                {
                    $price_range     = get_post_meta( $post_id, '_giftcard-price-range', true );
                    $prices          = explode( '-', $price_range );
                    $html            = __( 'Enter an amount between ', 'GIFTCARD') . wc_price($prices[0]) . __( ' and ', 'GIFTCARD' ) . wc_price($prices[1]);
                    $html            = __( 'From', 'GIFTCARD' ) . ' ' . wc_price($prices[0]) . __( ' to ', 'GIFTCARD' ) . wc_price($prices[1]);
                    $placeholder     = $prices[0] . '-' . $prices[1];

                    return $html;
                    break;
                }
                default:
                    return $price;
                    break;
            }
        } else {
            return $price;
        }
    }

    public function apply_giftcard(){
        global $woocommerce, $wpdb;

        if(!isset($_POST['product_id'])) return;
        $product = $_POST['product_id'];
        $productId = explode(' ', $product);
        if (!empty($_POST['giftcard_code'])) {

            $flag = true;
            $giftCardCode = sanitize_text_field($_POST['giftcard_code']);

            //get gift card if it is available check balance , status , expiry date
            $giftcard = new \model\Magenest_Giftcard($giftCardCode);
            $woocommerce->session->giftcard_applied = [
                'giftcard_code' => $giftCardCode,
                'giftcard_for_product' => 0,
                'giftcard_for_tax' => 0,
                'giftcard_for_ship' => 0,
                'giftcard_for_fee' => 0,
                'total_reduce' => 0
            ];
            if ($giftcard->is_valid($giftCardCode,$productId)) {
                // check apply for other gift card
                $check = get_option('magenest_giftcard_buy_other_giftcard', 'no');
                if ($check == 'no') {
                    foreach ($productId as $product_id) {
                        $is_giftcard = get_post_meta($product_id, '_giftcard', true);
                        if ($is_giftcard == 'yes') {
                            if (isset($woocommerce->session->giftcard_applied)) unset($woocommerce->session->giftcard_applied);
                            wc_add_notice(__('A gift card can not be used to buy other gift card', 'GIFTCARD'), 'error');
                            return;
                        }
                    }
                }
                wc_add_notice(__('Gift card applied successfully.', 'GIFTCARD'), 'success');
            } else {
                if (isset($woocommerce->session->giftcard_applied)) unset($woocommerce->session->giftcard_applied);
                if($giftcard->error_message){
                    wc_add_notice(__($giftcard->error_message), 'error');
                }else{
                    wc_add_notice(__('Gift card is not valid.', GIFTCARD_TEXT_DOMAIN), 'error');
                }
            }
        }
    }

    public function checkGiftCardInCart($passed_validation,$cart_item_key, $values, $quantity){
        global $woocommerce, $wpdb;
        $product_id = $values['product_id'];
        $is_giftcard = get_post_meta($product_id, '_giftcard', true);
        $_product = $values['data'];
        if($is_giftcard == "yes"){
            $giftcard_option = $values['giftcard_option'];
            $giftcard_amount = $giftcard_option['amount']['value'];
            $giftcardCodeMode = get_post_meta($product_id,'_giftcard_mode',true);
            if($giftcardCodeMode == "manual"){
                $sql = "SELECT `post_id` as `giftcard_code_id` FROM `".$wpdb->prefix."postmeta` WHERE `meta_key` = 'gc_product_id' AND `meta_value` = ".$product_id;
                $results = $wpdb->get_results($sql, ARRAY_A);
                if(!empty($results)){
                    $giftcard_value = [];
                    foreach ($results as $result){
                        $giftcard_code_id[] = $result['giftcard_code_id'];
                        $query = "SELECT * FROM `".$wpdb->prefix."postmeta` WHERE `post_id` = ".$result['giftcard_code_id'];
                        $giftcardcode = $wpdb->get_results($query,ARRAY_A);
                        $value = get_post_meta($result['giftcard_code_id'],'gc_balance', true);
                        foreach ($giftcardcode as $giftcard){
                            if($giftcard['meta_key'] == 'gc_status' && ($giftcard['meta_value'] == '-1' || $giftcard['meta_value'] == -1) && $value !="" && $giftcard_amount == $value){
                                $giftcard_value[] = $value;
                            }
                        }
                    }
                    if(count($giftcard_value) < $quantity){
                        wc_add_notice( sprintf( __( 'You can only add %s %s in your cart.', 'GIFTCARD' ),count($giftcard_value), $_product->get_name() ), 'error' );
                        $passed_validation = false;
                    }
                }
            }
        }
        return $passed_validation;
    }

    public function decrease_cart_total($cart_total, $cart){
        global $woocommerce;
        if (!isset($woocommerce->session->giftcard_applied)) {
            return $cart_total;
        } else {
            $gc_code = $woocommerce->session->giftcard_applied['giftcard_code'];
            $giftcard_applied['giftcard_code'] = $gc_code;
            $giftcard = new \model\Magenest_Giftcard($gc_code);
            $gc_amount = $giftcard->balance;

            $gc_need_for_product = 0;
            foreach ($cart->cart_contents as $key => $product) {
                if (isset($product['line_total'])) $gc_need_for_product += $product['line_total'];
            }
            $gc_for_product = ($gc_amount > $gc_need_for_product) ? $gc_need_for_product : $gc_amount;
            $gc_remain_amount = $gc_amount - $gc_for_product;
            $giftcard_applied['giftcard_for_product'] = $gc_for_product;

            if (get_option('magenest_enable_giftcard_charge_tax', 'no') == 'yes'){
                $gc_need_for_tax = $cart->get_total_tax();
                $gc_for_tax = ($gc_remain_amount > $gc_need_for_tax) ? $gc_need_for_tax : $gc_remain_amount;
                $gc_remain_amount = $gc_remain_amount - $gc_for_tax;
                $giftcard_applied['giftcard_for_tax'] = $gc_for_tax;
            }

            if (get_option('giftcard_apply_for_shipping') == 'yes'){
                $gc_need_for_shipping = $cart->get_shipping_total();
                $gc_for_shipping = ($gc_remain_amount > $gc_need_for_shipping) ? $gc_need_for_shipping : $gc_remain_amount;
                $gc_remain_amount = $gc_remain_amount - $gc_for_shipping;
                $giftcard_applied['giftcard_for_ship'] = $gc_for_shipping;
            }

            if (get_option('magenest_enable_giftcard_charge_fee') == 'yes'){
                $gc_need_for_fee = $cart->get_fee_total();
                $gc_for_fee = ($gc_remain_amount > $gc_need_for_fee) ? $gc_need_for_fee : $gc_remain_amount;
                $gc_remain_amount = $gc_remain_amount - $gc_for_fee;
                $giftcard_applied['giftcard_for_fee'] = $gc_for_fee;
            }
            $reduce_amount = $gc_amount - $gc_remain_amount;
            $giftcard_applied['total_reduce'] = $reduce_amount;
            $woocommerce->session->giftcard_applied = $giftcard_applied;
            return $cart_total - $reduce_amount;
        }
    }

    public function show_giftcard_discount_in_cart()
    {
        global $woocommerce;
        if (isset($woocommerce->session->giftcard_applied)) {
            ?>
            <tr class="order-discount giftcard-discount">
                <th><?php echo __('Gift card',GIFTCARD_TEXT_DOMAIN) ?> : <?php echo $woocommerce->session->giftcard_applied['giftcard_code'] ?></th>
                <td>
                    <form method="POST" id="giftcard-remove-apply-form">
                        <input type="hidden" name="action" value="removegiftcardcode"/>
                        <input type="hidden" id="magenest_giftcardcode" value="<?= $woocommerce->session->giftcard_applied['giftcard_code']; ?>"/>
                        <div>-<?php echo wc_price($woocommerce->session->giftcard_applied['total_reduce']) ?> <a href="#" id="btn_remove_gc"><?php echo __('Remove', 'GIFTCARD'); ?></a></div>
                        <?php echo $this->show_details_gc_discount($woocommerce->session->giftcard_applied); ?>
                    </form>
                </td>
            </tr>
            <?php
        }
    }

    public function display_tax_amount_after_apply_gc($total_tax, $compound, $display, $cart){
        global $woocommerce;
        if (!isset($woocommerce->session->giftcard_applied)) {
            return $total_tax;
        } else {
            return $total_tax - $woocommerce->session->giftcard_applied['giftcard_for_tax'];
        }
    }

    public function display_shipping_amount_after_apply_gc($total_shipping){
        global $woocommerce;
        if (!isset($woocommerce->session->giftcard_applied)) {
            return $total_shipping;
        } else {
            return $total_shipping - $woocommerce->session->giftcard_applied['giftcard_for_ship'];
        }
    }

    public function remove_giftcard_code()
    {
        global $woocommerce, $wpdb;
        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'removegiftcardcode') {
            $woocommerce->session->__unset('giftcard_applied');
            wc_add_notice(__('Gift card code removed successfully.', 'GIFTCARD'), 'success');
        }
    }

    public function check_gc_valid_before_checkout(){
        global $woocommerce;
        if (isset($woocommerce->session->giftcard_applied)) {
            $giftcard = new \model\Magenest_Giftcard($woocommerce->session->giftcard_applied['giftcard_code']);
            $gc_amount = $giftcard->balance; // from database

            $gc_reduce = $woocommerce->session->giftcard_applied['total_reduce']; //calculated from the cart

            if ($gc_amount < $gc_reduce){
                throw new Exception(__('Error due to wrong pricing with gift card code. Please refresh page!','GIFTCARD'));
            }
        }

    }

    public function process_after_checkout_sucess($order_id)
    {
        global $woocommerce, $wpdb;
        if (isset($woocommerce->session->giftcard_applied)) {
            update_post_meta($order_id, 'giftcard_applied', json_encode($woocommerce->session->giftcard_applied));
            // reduce gift card balance
            $giftcard = new \model\Magenest_Giftcard($woocommerce->session->giftcard_applied['giftcard_code']);
            $giftcard->add_balance(-1 * number_format($woocommerce->session->giftcard_applied['total_reduce']), $woocommerce->session->giftcard_applied['giftcard_code']);

            //log
            $order =  new \WC_Order($order_id);
            $log = '';
            foreach ( $order->get_items () as $item ) {
                $product = $item->get_data();
                $product_name = $product['name'];
                $product_price = $product['total'];
                $log .= $product_name.': ' .$product_price;
            }
            $balance = (float)($giftcard->balance - $woocommerce->session->giftcard_applied['total_reduce']);
            $data = array(
                'giftcard_id' => $giftcard->id,
                'giftcard_code' => $woocommerce->session->giftcard_applied['giftcard_code'],
                'balance' => $balance,
                'change_balanced' => $woocommerce->session->giftcard_applied['total_reduce'],
                'order_id' => $order_id,
                'log' => $log
            );

            $giftcard->InsertRedeemLog($data);

            $woocommerce->session->__unset('giftcard_applied');
        }
    }

    public function show_giftcard_discount_on_order($total_rows, $order)
    {
        global $woocommerce;

        $return = array();

        $order_id = $order->get_id();

        $gc_applied = json_decode(get_post_meta($order_id, 'giftcard_applied', true), true);

        if ($gc_applied && $gc_applied != '') {
            $newRow['giftcard'] = array(
                'label' => __('Gift Card Payment', 'GIFTCARD') . '(' . $gc_applied['giftcard_code'] . ')',
                'value' => wc_price(-1 * $gc_applied['total_reduce']) . $this->show_details_gc_discount($gc_applied)
            );

            array_splice($total_rows, 1, 0, $newRow);
        }

        return $total_rows;
    }

    public function display_giftcard_on_order ( $order_id ) {
        $gc_applied = json_decode(get_post_meta($order_id, 'giftcard_applied', true), true);
        if( $gc_applied['total_reduce'] > 0 ) {
            ?>
            <tr>
                <td class="label"><?php _e( 'Gift Card Payment' , 'GIFTCARD' ) . '(' .$gc_applied['giftcard_code'].')'; ?>:</td>
                <td class="giftcardTotal">
                    <div class="view"><?php echo '-'. wc_price( $gc_applied['total_reduce'] ); ?></div>
                    <?php echo  $this->show_details_gc_discount($gc_applied)?>
                </td>
            </tr>
            <?php
        }

    }

    private function show_details_gc_discount($giftcard_applied){
        $html = '<div>(' .__('Subtotal:') .' -'. wc_price($giftcard_applied['giftcard_for_product']);
        if ($giftcard_applied['giftcard_for_tax'] != 0){
            $html .= '<br/>';
            $html .= __('Tax:') .' -'. wc_price($giftcard_applied['giftcard_for_tax']);
        }
        if ($giftcard_applied['giftcard_for_ship'] != 0){
            $html .= '<br/>';
            $html .= __('Shipping:') .' -'. wc_price($giftcard_applied['giftcard_for_ship']);

        }
        if ($giftcard_applied['giftcard_for_fee'] != 0){
            $html .= '<br/>';
            $html .= __('Fee:') .' -'. wc_price($giftcard_applied['giftcard_for_fee']);
        }
        $html .= ')</div>';

        return $html;
    }
}