<?php

namespace ZAddons;

class DB
{
    const Prefix = "za_";
    /* Tables */
    const Groups = 'groups';
    const Products2Groups = 'products_to_groups';
    const Categories2Groups = 'categories_to_groups';
    const Types = 'types';
    const Values = 'values';
    const AddOns = 'add_ons';
    const Headers = 'headers';

    public static function db_activate()
    {
        global $wpdb;
        $prefix = $wpdb->prefix . static::Prefix;
        self::check_new_table();
        $tables = get_option('zaddons_tables', []);

        if (!in_array('base', $tables)) {
            $groups = $prefix . static::Groups;
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${groups}` (
				id BIGINT(20) UNSIGNED PRIMARY KEY AUTO_INCREMENT,
				author BIGINT(20) UNSIGNED DEFAULT 0,
				title TEXT,
				visibility VARCHAR(20) DEFAULT 'public',
				priority INT(2),
				created_at DATETIME DEFAULT '0000-00-00 00:00:00',
				created_at_gmt DATETIME DEFAULT '0000-00-00 00:00:00',
				updated_at DATETIME DEFAULT '0000-00-00 00:00:00',
				updated_at_gmt DATETIME DEFAULT '0000-00-00 00:00:00'
			);"
            );

            $p2g = $prefix . static::Products2Groups;
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${p2g}` (
					product_id BIGINT(20) UNSIGNED NOT NULL,
					group_id BIGINT(20) UNSIGNED NOT NULL
				);"
            );

            $c2g = $prefix . static::Categories2Groups;
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${c2g}` (
				category_id BIGINT(20) UNSIGNED NOT NULL,
				group_id BIGINT(20) UNSIGNED NOT NULL
			);"
            );

            $types = $prefix . static::Types;
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${types}` (
				id BIGINT(20) UNSIGNED PRIMARY KEY AUTO_INCREMENT,
				group_id BIGINT(20) UNSIGNED NOT NULL,
				title TEXT,
				step INT(2),
				type VARCHAR(250),
				accordion VARCHAR(10),
				description VARCHAR(250),
				required TINYINT(1) DEFAULT 0,
				created_at DATETIME DEFAULT '0000-00-00 00:00:00',
				created_at_gmt DATETIME DEFAULT '0000-00-00 00:00:00',
				updated_at DATETIME DEFAULT '0000-00-00 00:00:00',
				updated_at_gmt DATETIME DEFAULT '0000-00-00 00:00:00'
			);"
            );

            $values = $prefix . static::Values;
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${values}` (
				id BIGINT(20) UNSIGNED PRIMARY KEY AUTO_INCREMENT,
				type_id BIGINT(20) UNSIGNED NOT NULL,
				title TEXT,
				step INT(2),
				price FLOAT,
				description VARCHAR(250),
				checked TINYINT(1) DEFAULT 0,
				created_at DATETIME DEFAULT '0000-00-00 00:00:00',
				created_at_gmt DATETIME DEFAULT '0000-00-00 00:00:00',
				updated_at DATETIME DEFAULT '0000-00-00 00:00:00',
				updated_at_gmt DATETIME DEFAULT '0000-00-00 00:00:00'
			);"
            );


            $tables[] = 'base';
            $tables[] = 'accordion';
        }

        if (!in_array('apply_to_groups', $tables)) {

            $wpdb->query("
			  ALTER TABLE `${groups}` ADD `apply_to` ENUM('custom', 'all', 'cart', 'checkout', 'cart_checkout') NOT NULL DEFAULT 'custom';
			");

            $tables[] = 'apply_to_groups';
            $tables[] = 'additional_enum_values';
        }

        update_option('zaddons_tables', $tables);
    }

    public static function check_new_table() {
        global $wpdb;
        $tables = get_option('zaddons_tables', []);

        if (in_array('add_ons', $tables) && in_array('header_text', $tables) && in_array('additional_enum_values', $tables)
            && in_array('header_types', $tables) && in_array('accordion', $tables))
            return;

        $prefix = $wpdb->prefix . static::Prefix;
        $groups = $prefix . static::Groups;

        if (!in_array('additional_enum_values', $tables)) {
            $wpdb->query("
			  ALTER TABLE `${groups}` MODIFY `apply_to` ENUM('custom', 'all', 'cart', 'checkout', 'cart_checkout') NOT NULL DEFAULT 'custom';
			");

            $tables[] = 'additional_enum_values';
        }

        if (!in_array('add_ons', $tables)){
            $add_ons = $prefix . static::AddOns;
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${add_ons}` (
                    id BIGINT(20) UNSIGNED PRIMARY KEY AUTO_INCREMENT,
                    title VARCHAR(50),
                    description VARCHAR(250),
                    hook_name VARCHAR(50),
                    plugin_link VARCHAR(250)
                );"
            );
            $tables[] = 'add_ons';
        }
        $headers = $prefix . static::Headers;

        if (!in_array('header_text', $tables)){
            $wpdb->query(
                "CREATE TABLE IF NOT EXISTS `${headers}` (
				id BIGINT(20) UNSIGNED PRIMARY KEY AUTO_INCREMENT,
				header_type ENUM('cart', 'checkout') NOT NULL DEFAULT 'checkout'
				header_text VARCHAR(70)
			    );"
            );
            $tables[] = 'header_text';
            $tables[] = 'header_types';
        }

        if (!in_array('header_types', $tables)){
            $header_type_exist = $wpdb->query(
                "SELECT column_name 
             FROM INFORMATION_SCHEMA.COLUMNS 
             WHERE TABLE_SCHEMA='" . DB_NAME . "' AND TABLE_NAME='${headers}' AND column_name='header_type';"
            );

            if (!$header_type_exist) {
                $wpdb->query(
                    "ALTER TABLE `${headers}` ADD COLUMN header_type ENUM('cart', 'checkout');"
                );
            }
            $tables[] = 'header_types';
        }

        if (!in_array('accordion', $tables)) {
            $types = $prefix . static::Types;
            $accordion_exist = $wpdb->query(
                "SELECT column_name 
             FROM INFORMATION_SCHEMA.COLUMNS 
             WHERE TABLE_SCHEMA='" . DB_NAME . "' AND TABLE_NAME='${types}' AND column_name='accordion';"
            );

            if (!$accordion_exist) {
                $wpdb->query(
                    "ALTER TABLE `${types}` ADD COLUMN accordion VARCHAR(10);"
                );
            }
            $tables[] = 'accordion';
        }


        update_option('zaddons_tables', $tables);
    }
}
